#version 330
#extension GL_EXT_gpu_shader4 : enable
//015 infinite torii IIMod01.fsh  by 9re
//https://www.shadertoy.com/view/wdBfRw
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float F = 3.8;
const float PI = 3.14159;
const vec4 c_pl = vec4(0., 1., 0., 0.);
const vec4 c_sp = vec4(1., 1., 1., 0.5);
const vec3 c_red_light = vec3(0.8, 0.6, 0.1);
const vec3 light_dir_0 = normalize(vec3(1.0, 0.3, -1.));
const vec3 c_blue_light = vec3(0.1, 0.3, 0.8);
//const vec3 c_dir_blue_light = normalize(vec3(0.7, 0.3, -0.9));
const float c_max_height = 0.8;
const float c_mod = 6.0;
const float c_spec = .2;
const float c_diffuse = .8;
const vec3 c_pavement = vec3(0.5);

vec2 resolution(vec2 p) {
    vec2 q = 2. * (p / iResolution.xy - .5);
    q.y *= iResolution.y / iResolution.x;
    return q;
}

float plane(in vec4 f, in vec3 p)
{
    return dot(f.xyz, p) + f.w;
}

// from Distance Functions - Inigo Quilez
// https://iquilezles.org/articles/distfunctions
float dot2( vec2 v ) { return dot(v,v); }

float box(in vec3 f, in vec3 p)
{
  vec3 q = abs(p) - f;
  return length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0);
}

float cappedCone(in float h, in float r1, in float r2, in vec3 p)
{
  vec2 q = vec2( length(p.xz), p.y );
  vec2 k1 = vec2(r2,h);
  vec2 k2 = vec2(r2-r1,2.0*h);
  vec2 ca = vec2(q.x-min(q.x,(q.y<0.0)?r1:r2), abs(q.y)-h);
  vec2 cb = q - k1 + k2*clamp( dot(k1-q,k2)/dot2(k2), 0.0, 1.0 );
  float s = (cb.x<0.0 && ca.y<0.0) ? -1.0 : 1.0;
  return s*sqrt( min(dot2(ca),dot2(cb)) );
}

vec2 torii(in vec3 p, in float time)
{
    vec2 d, d1;
    d = vec2(box(vec3(3.6, 0.3, 0.32), p - vec3(0., 4.3, 0.)), 1.0);
    d1 = vec2(box(vec3(1.9, 0.2, 0.18), p - vec3(0., 3.5, 0.)), 1.0);
    if (d.x > d1.x) {
        d = d1;
    }
    d1 = vec2(cappedCone(3.8, .25, .2, p - vec3(-2., 0.2, 0.)), 1.0);
    if (d.x > d1.x) {
        d = d1;
    }
    d1 = vec2(cappedCone(3.8, .25, .2, p - vec3(2., 0.2, 0.)), 1.0);
    if (d.x > d1.x) {
        d = d1;
    }
    d1 = vec2(cappedCone(.2, .25, .25, p - vec3(-2., 0., 0.)), 2.0);
    if (d.x > d1.x) {
        d = d1;
    }
    d1 = vec2(cappedCone(.2, .25, .25, p - vec3(2., 0., 0.)), 2.0);
    if (d.x > d1.x) {
        d = d1;
    }
    
    //d -= 0.02 * triNoise3d(p);
    
    return d;
}

vec2 map(in vec3 p, in float time)
{
    vec3 q = vec3(p);
    q.z = mod(q.z, c_mod);
    return torii(q, time);
}



// from Raymarching - Primitives - Inigo Quillez
// https://www.shadertoy.com/view/Xds3zN
vec3 normal(in vec3 pos, in float time) {
    vec2 e = vec2(1.0, -1.0) * 0.5773 * 0.0005;
    return normalize(e.xyy * map(pos + e.xyy, time).x + 
                                         e.yyx * map(pos + e.yyx, time).x + 
                                         e.yxy * map(pos + e.yxy, time).x + 
                                         e.xxx * map(pos + e.xxx, time).x );
}

vec3 material(in vec3 p, in float time) {
    vec3 c;
    vec2 d = map(p, time);
        
    if (d.x > 0.01) {
        c.x = -1.;
    } else {
        if (d.y > 0.5 && d.y < 1.5) {
            c = vec3(0.937, 0.27, 0.29);
        }
    }
    
    return c;
}

vec2 march(in vec3 cam, in vec3 ray, in float time)
{
    vec2 d = vec2(1., -1.);
    
    float t = dot(c_pl.xyz, ray) * (dot(c_pl.xyz, cam) + c_pl.w);
    if (t > 0.) {
        d.x = 10000.;
        d.y = -1.;
    } else {
        d.x = t;
        d.y = 1.;
    }
    
    vec3 p;
    t = 1.;
    for (float r = 0.; r < 96.; r += 1.) {
        p = cam + t * ray;
        vec2 dt = map(p, time);
        if (abs(dt.x) < .0001 * t) {
            d.x = t;
            d.y = dt.y;
            break;
        }
        if (p.y < 0.) {
            d.x = 10000.;
            d.y = -1.;
            break;
        }
        t += dt.x;
        if (t > 60.) {
            break;
        }
    }
    
    
    return d;
}


// from penumbra shadows in raymarched SDFs - Inigo Quilez
// https://iquilezles.org/articles/rmshadows

float calcSoftshadow( in vec3 ro, in vec3 rd, in float time, in float mint, in float tmax )
{
    // bounding volume
    float tp = (c_max_height - ro.y)/rd.y; if( tp>0.0 ) tmax = min( tmax, tp );

    float res = 1.0;
    float t = mint;
    for( int i=0; i<16; i++ )
    {
		float h = map( ro + rd*t, time ).x;
        float s = clamp(8.0*h/t,0.0,1.0);
        res = min( res, s*s*(3.0-2.0*s) );
        t += clamp( h, 0.02, 0.10 );
        if( res<0.005 || t>tmax ) break;
    }
    return clamp( res, 0.0, 1.0 );
}

//https://www.shadertoy.com/view/4sf3D2
float hash(vec2 p) {return fract(sin(p.x * 1e4 + p.y) * 1e5 + sin(p.y * 1e3) * 1e3 + sin(p.x * 735. + p.y * 11.1) * 1.5e2); }

// Returns three values on [-1, +1]: 
// vec3(d noise(x,y) / dx, d noise(x, y) / dy, noise(x,y));

vec3 noised(vec2 x) {
    vec2 p = floor(x);
    vec2 f = fract(x);

	// Four corners in 2D of a tile
	float a = hash(p);
    float b = hash(p + vec2(1.0, 0.0));
    float c = hash(p + vec2(0.0, 1.0));
    float d = hash(p + vec2(1.0, 1.0));

    vec2 u, v;
    u = 30.0 * f * f * (f * (f - 2.0) + 1.0);
    v = f * f * f * (f * (f * 6.0 - 15.0) + 10.0);
	
	float noiseValue = 
	 	mix(mix(a, b, v.x), mix(c, d, v.x), v.y);
	
	return vec3(u * (vec2(b, c) + (a - b - c + d) * v.yx - a),
				noiseValue);
}
float hash(float n) { return fract(sin(n) * 1e4); }
vec2 hash2( vec2 p )
{
	return fract(sin(vec2(dot(p,vec2(127.1,311.7)),dot(p,vec2(269.5,183.3))))*43758.5453);
}

// Based on Morgan McGuire @morgan3d
// https://www.shadertoy.com/view/4dS3Wd
float noise (in vec2 st) {
    vec2 i = floor(st);
    vec2 f = fract(st);

    // Four corners in 2D of a tile
    float a = hash2(i).x;
    float b = hash2(i + vec2(1.0, 0.0)).x;
    float c = hash2(i + vec2(0.0, 1.0)).x;
    float d = hash2(i + vec2(1.0, 1.0)).x;

    vec2 u = f * f * (3.0 - 2.0 * f);

    return mix(a, b, u.x) +
            (c - a)* u.y * (1.0 - u.x) +
            (d - b) * u.x * u.y;
}
// This one has non-ideal tiling properties that I'm still tuning
float noise(vec3 x) {
	const vec3 step = vec3(110, 241, 171);

	vec3 i = floor(x);
	vec3 f = fract(x);
 
	// For performance, compute the base input to a 1D hash from the integer part of the argument and the 
	// incremental change to the 1D based on the 3D -> 1D wrapping
    float n = dot(i, step);

	vec3 u = f * f * (3.0 - 2.0 * f);
	return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y),
               mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z);
}

#define OCTAVES 6
float fbm (in vec2 st) {
    // Initial values
    float value = 0.0;
    float amplitude = .5;
    float frequency = 0.;
    //
    // Loop of octaves
    for (int i = 0; i < OCTAVES; i++) {
        value += amplitude * noise(st);
        st *= 2.;
        amplitude *= .5;
    }
    return value;
}

float fbm (in vec3 st) {
    // Initial values
    float value = 0.0;
    float amplitude = .5;
    float frequency = 0.;
    //
    // Loop of octaves
    for (int i = 0; i < OCTAVES; i++) {
        value += amplitude * noise(st);
        st *= 2.;
        amplitude *= .5;
    }
    return value;
}

vec3 phong(vec3 v, vec3 n, vec3 l, vec3 c, float d, float s, float sa, vec3 a) {
    vec3 h = normalize(l - v);
    return max(dot(n, l), 0.) * c * d + pow(max(dot(n, h), 0.), sa) * c * s + a * 0.4;
}

vec3 pavement(in vec3 ray, in vec2 x)
{
    // based on voronoi from iq's - https://www.shadertoy.com/view/ldl3W8
    vec2 n = floor(x);
    vec2 f = fract(x);

	vec2 mg, mr;

    float md = 8.0;
    for( int j=-1; j<=1; j++ )
    for( int i=-1; i<=1; i++ )
    {
        vec2 g = vec2(float(i),float(j));
		vec2 o = hash2(n + g);
        vec2 r = g + o - f;
        float d = dot(r,r);

        if( d<md )
        {
            md = d;
            mr = r;
            mg = g;
        }
    }

    md = 8.0;
    vec2 mp, mo;
    for( int j=-2; j<=2; j++ )
    for( int i=-2; i<=2; i++ )
    {
        vec2 g = mg + vec2(float(i),float(j));
		vec2 o = hash2(n + g);
        vec2 r = g + o - f;

        if(dot(mr-r, mr-r) > 0.00001) {
            vec2 p = normalize(r - mr);
            float nd = dot( 0.5 * (mr + r), p);
            if (nd < md) {
                md = nd;
                mo = o;
                mp = p;
            }
        }
    }
    
    float r = 0.19;
    md = clamp(md, 0., r) / r;
    vec3 c = fbm(1.6 * x) * .5 + vec3(.5);
    vec3 norm;
    if (md == 1.0) {
        norm = vec3(0., 1., 0.);
    } else {
        float t = .1 + mo.y * .3;
        float cs = cos(t);
        float ct = 1. - cs; 
        float sn = sin(t);
        norm = vec3(-mp.x * mp.y * ct, cs + mp.x * mp.x * ct, -mp.y * sn);
    }

    c *= phong(ray, norm, light_dir_0, vec3(1.), .9, .4, 30., vec3(0.9));
    c *= smoothstep(.03, .2, md);
    c = pow(c, vec3(1.4));
    
    return c;
}

vec3 fog(in vec3 col, in vec3 ro, in vec3 rd, in float mt)
{
    float d = mt - .1;
    float r = .9;
    float f = 0.;
    for(int i=0;  i < 5; i++)
    {
        vec3  pos = ro + rd * d;
        float rz = fbm(pos + vec3(iTime * .5, 0., 0.));
        f += rz * .25 * pow(1.3, (d - 11.) * .15);
        if (d < 5.) break;
        d *= r;
    }
    f = smoothstep(0.4, 0.95, f);
    f = pow(f, 1.3);
    return mix(col, vec3(.8, .8, .9), f);
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    vec2 mouse = resolution(iMouse.xy);
    vec3 camera = vec3(0., 1.7,  -10.  - iTime * .8 - 100.);
    vec3 lookAt = normalize(vec3(0., 1. + mouse.y * 2., .5) + camera);
    float roll = 0.;
    
    vec3 cy = normalize(vec3(0., 1., 0.) - lookAt.y * lookAt);
    vec3 cx = cross(lookAt, cy);
    
    vec2 uv = resolution(gl_FragCoord.xy);
    
    vec3 tot;
    vec3 ray = normalize(uv.x * cx + uv.y * cy + F * lookAt);
    
    vec2 d = march(camera, ray, iTime);
    vec3 c = vec3(0., 0., 0.);
    
    float dt = 0.;
    vec3 c_dir_red_light = normalize(vec3(cos(dt - PI * 1.2), 0.7, sin(dt - PI * 1.2)));
    vec3 c_dir_blue_light = normalize(vec3(cos(dt), 0.3, sin(dt)));
    
    float rz;
    if (d.y > .5) {
	    vec3 p = camera + d.x * ray;
        vec3 n = normal(p, iTime);
        c = material(p, iTime);
        c += phong(ray, n, c_dir_blue_light, c_blue_light, 0.3, 0.12, 10., c);
        c += phong(ray, n, c_dir_red_light, c_red_light, 0.3, 0.12, 10., c);
        c *= calcSoftshadow(p, c_blue_light, iTime, 0.02, 2.5 );
        c = pow(c,vec3(1.2, 2.4, 1.64));

        rz = d.x;
    } else {
        float t = -(dot(c_pl.xyz, camera) + c_pl.w) / dot(c_pl.xyz, ray);
        vec3 q = camera + t * ray;
        if (t > 0.) {
            if (abs(q.x) < 1.4) {
                c = pavement(ray, q.xz * vec2(2., 1.));
            } else {
                vec3 noise = noised(q.xz * 1.2);
                vec3 n = -normalize(cross(vec3(1., noise.x, 0.), vec3(0., noise.y, 1.)));
                c = vec3(0.412, 0.38, 0.28);
                c += phong(ray, n, c_dir_red_light, c_red_light, 0.8, 0.1, 20., c);
	            c = pow(c, vec3(1.5));
            }
        }
        rz = t;
    }
	c = fog(c, camera, ray, rz);

    c *= smoothstep(.0001, 1., 10.5 / rz);
    
    // Output to screen
    gl_FragColor = vec4(c, 1.0);
}
